/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item;

import committee.nova.mods.avaritia.api.common.container.SimpleContainer;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.util.ContainerUtils;
import committee.nova.mods.avaritia.util.ItemUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatterClusterItem
extends Item {
    public static int CAPACITY = 4096;

    public MatterClusterItem() {
        super(new Item.Properties().m_41497_(ModRarities.RARE).m_41487_(1));
    }

    public static int getClusterSize(ItemStack cluster) {
        if (cluster.m_41782_() || !cluster.m_41784_().m_128425_("items", 9)) {
            return Arrays.stream(MatterClusterItem.readClusterInventory((ItemStack)cluster).items).mapToInt(ItemStack::m_41613_).sum();
        }
        return 0;
    }

    public static List<ItemStack> makeClusters(Collection<ItemStack> input) {
        LinkedList<ItemStack> clusters = new LinkedList<ItemStack>();
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>(input);
        while (!stacks.isEmpty()) {
            int totalInserted;
            int remainder;
            ItemStack cluster;
            SimpleContainer clusterInventory = new SimpleContainer(512);
            for (totalInserted = 0; !stacks.isEmpty() && totalInserted < CAPACITY; totalInserted += cluster.m_41613_() - remainder) {
                cluster = stacks.poll();
                remainder = ContainerUtils.insertItem(clusterInventory, cluster, false);
                if (remainder <= 0) continue;
                cluster.m_41764_(remainder);
                stacks.add(cluster);
                break;
            }
            if (totalInserted <= 0) continue;
            cluster = new ItemStack((ItemLike)ModItems.matter_cluster.get());
            MatterClusterItem.writeClusterInventory(cluster, clusterInventory);
            clusters.add(cluster);
        }
        return clusters;
    }

    public static boolean mergeClusters(ItemStack donor, ItemStack recipient) {
        SimpleContainer receivingInv = MatterClusterItem.readClusterInventory(recipient);
        int recipientCount = Arrays.stream(receivingInv.items).mapToInt(ItemStack::m_41613_).sum();
        if (recipientCount >= CAPACITY) {
            return false;
        }
        boolean mergedAny = false;
        SimpleContainer donorInv = MatterClusterItem.readClusterInventory(donor);
        for (ItemStack stack : donorInv.items) {
            if (stack.m_41619_()) break;
            int remainder = ContainerUtils.insertItem(receivingInv, stack, false);
            if (remainder <= stack.m_41613_()) {
                mergedAny = true;
            }
            stack.m_41764_(remainder);
            if ((recipientCount += stack.m_41613_() - remainder) >= CAPACITY) break;
        }
        MatterClusterItem.writeClusterInventory(recipient, receivingInv);
        int donorRemaining = Arrays.stream(donorInv.items).mapToInt(ItemStack::m_41613_).sum();
        if (donorRemaining == 0) {
            donor.m_41751_(null);
            donor.m_41764_(0);
        } else {
            MatterClusterItem.writeClusterInventory(donor, donorInv);
        }
        return mergedAny;
    }

    private static void writeClusterInventory(ItemStack cluster, SimpleContainer clusterContents) {
        CompoundTag nbt = cluster.m_41784_();
        nbt.m_128365_("items", (Tag)MatterClusterItem.writeItemStacksToTag(clusterContents.items));
    }

    private static SimpleContainer readClusterInventory(ItemStack cluster) {
        SimpleContainer clusterInventory = new SimpleContainer(512);
        if (cluster.m_41782_()) {
            MatterClusterItem.readItemStacksFromTag(clusterInventory.items, cluster.m_41784_().m_128437_("items", 10));
        }
        return clusterInventory;
    }

    private static ListTag writeItemStacksToTag(ItemStack[] items) {
        ListTag tagList = new ListTag();
        for (ItemStack item : items) {
            if (item.m_41619_()) continue;
            tagList.add((Object)item.m_41739_(new CompoundTag()));
        }
        return tagList;
    }

    private static void readItemStacksFromTag(ItemStack[] items, ListTag tagList) {
        for (int i = 0; i < tagList.size(); ++i) {
            items[i] = ItemStack.m_41712_((CompoundTag)tagList.m_128728_(i));
        }
    }

    public void m_7373_(ItemStack stack, Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (stack.m_41782_() || !stack.m_41784_().m_128425_("items", 9)) {
            SimpleContainer inventory = MatterClusterItem.readClusterInventory(stack);
            int total = Arrays.stream(inventory.items).mapToInt(ItemStack::m_41613_).sum();
            tooltip.add((Component)Component.m_237110_((String)"tooltip.matter_cluster.counter", (Object[])new Object[]{total, Math.max(total, CAPACITY)}));
            tooltip.add((Component)Component.m_237113_((String)""));
            if (Screen.m_96638_()) {
                Object2IntOpenHashMap itemCounts = new Object2IntOpenHashMap();
                for (ItemStack item : inventory.items) {
                    if (item.m_41619_()) break;
                    itemCounts.put((Object)item.m_41720_(), item.m_41613_() + itemCounts.getOrDefault((Object)item.m_41720_(), 0));
                }
                itemCounts.forEach((itemx, count) -> tooltip.add((Component)Component.m_237115_((String)itemx.m_5524_()).m_130938_(itemx.m_41460_(new ItemStack((ItemLike)itemx)).getStyleModifier()).m_7220_((Component)Component.m_237113_((String)(" x " + count)).m_130940_(ChatFormatting.GRAY))));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.matter_cluster.desc").m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.matter_cluster.desc2").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            ItemUtils.dropInventory(level, player.m_20183_(), MatterClusterItem.readClusterInventory(stack));
        }
        player.m_21008_(hand, ItemStack.f_41583_);
        return InteractionResultHolder.m_19090_((Object)ItemStack.f_41583_);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.m_20185_(), location.m_20186_(), location.m_20189_(), stack);
    }
}

